#!/usr/bin/python3
import socket
import ssl
import pprint
import sys
import time

HOST= '127.0.0.1'
PORT= 7777

# echo server
def echo(connstream):
    while True:
        data = connstream.recv(1500)
        if data == b'' or data == b'\n' : break
        print(data)
        connstream.sendall(data)
        
# main program
context = ssl.create_default_context(ssl.Purpose.CLIENT_AUTH)
context.load_cert_chain(certfile="server.crt", keyfile="server.key")
bindsocket = socket.socket()
bindsocket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
bindsocket.bind((HOST, PORT))
bindsocket.listen(5)

while True:
    newsocket, fromaddr = bindsocket.accept()
    connstream = context.wrap_socket(newsocket, server_side=True)
    print('Connected by', fromaddr)
    try:
        echo(connstream)
    except ssl.SSLError as e:
        print('SSLError', e)
    finally:
        connstream.close()
        print('Disconnected by', fromaddr)        

bindsocket.close()
