#!/usr/bin/python3
import socket
import ssl
import pprint
import sys

HOST=b"127.0.0.1"
PORT=7777


print("HOST:", HOST.decode())
print("PORT:", PORT)

context = ssl.create_default_context(ssl.Purpose.SERVER_AUTH)
context.load_verify_locations("ca.crt")
s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
conn = context.wrap_socket(s, server_hostname=HOST)
conn.connect((HOST, PORT))
cert = conn.getpeercert()
print("SERVER CERT:")
pprint.pprint(cert)
request = b"Hello from " + HOST + b"\r\n"
print("REQUEST:")
print(request.decode())
conn.sendall(request)
answer = conn.recv(1024)
print("ANSWER:")
print(answer.decode())
conn.close()
